﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.Text;
using System.Activities;
using System.Activities.Statements;

namespace EvenOddWfUsingActivity
{
    // Tworzenie klasy pochodnej od klasy Activity i zwracającej wartość typu string.
  public class EvenOddWfActivity : Activity<string>
  {

    // Definicja argumentu wejściowego procesu.
    [RequiredArgument]
    public InArgument<int> NumberToCheck { get; set; }

    // Tworzenie konstruktora czynności w celu zdefiniowania
    // jej implementacji.
    public EvenOddWfActivity()
    {
        // Tworzenie zmiennej wyjściowej w celu zapisania efektów działania czynności.
      Variable result = new Variable<string> { Name="OutputMsg", Default=null };

      // Definiowanie implementacji jako nowej czynności typu Sequence.
      this.Implementation = () => new Sequence
      {
          // Ustawianie nazwy obiektu Sequence i konfigurowanie zmiennej result.
        DisplayName = "Główna sekwencja",
        Variables = { result },

          // Dodawanie czynności If i Assign do czynności Sequence.
        Activities = 
        {
          // Tworzenie czynności If.
          new If()
          {
            DisplayName = "Jeśli liczba jest parzysta",

            // Ustawianie właściwości Condition na wyrażenie lambda porównujące
            // argument wejściowy z wartością Mod 2 = 0.
            Condition = new InArgument<bool>((env) => 
              this.NumberToCheck.Get(env) % 2 == 0),
            
            // Ustawianie parametru 'Then' na nową czynność Assign ustawiającą
            // zmienną result na wartość "parzysta".
            Then = new Assign<string>
            {
              To = result ,
              Value = new InArgument<string>("parzysta")
            },

            // Ustawianie parametru 'Else' na nową czynność Assign przypisującą 
            // do zmiennej result wartość "nieparzysta".
            Else = new Assign<string>
            {
              To = result,
              Value = new InArgument<string>("nieparzysta")
            }        
          }, 

          // Dodawanie ostatniej czynności Assign do czynności Sequence, aby
          // ustawić zwracany wyjściowy parametr obiektu Activity<TResult>.
          new Assign<string>
          {
            DisplayName = "Przypisywanie wyniku do argumentu wyjściowego",
            To = new OutArgument<string>(env => this.Result.Get(env)),
            Value = new InArgument<string>(env => 
              "Podana liczba, " + this.NumberToCheck.Get(env).ToString() + 
              ", jest " + result.Get(env))      
          }
        }
      };
    }
  }
}